--[[
GreenBeanAndPeaHarvestAddon

Specialization to allow harvest green beans and peas with an harvester

Author: 	Ifko[nator]
Date: 		10.05.2025
Version:	1.0

History:	v1.0 @10.05.2025 - initial implemation in FS 25
]]

GreenBeanAndPeaHarvestAddon = {}
GreenBeanAndPeaHarvestAddon.xmlSchema = {};

GreenBeanAndPeaHarvestAddon.currentModDirectory = g_currentModDirectory;

if GreenBeanAndPeaHarvestAddon.modDesc == nil then
    GreenBeanAndPeaHarvestAddon.modDesc = XMLFile.load("modDesc", Utils.getFilename("modDesc.xml", GreenBeanAndPeaHarvestAddon.currentModDirectory), GreenBeanAndPeaHarvestAddon.xmlSchema);
end;

if GreenBeanAndPeaHarvestAddon.modDesc ~= nil then
    GreenBeanAndPeaHarvestAddon.currentModName = g_currentModName;
    
    function GreenBeanAndPeaHarvestAddon:motionPathEffectManagerLoadMapData(xmlFile, missionInfo, baseDirectory)
        MotionPathEffectManager.createMotionPathEffectXMLSchema();

        g_motionPathEffectManager:loadMotionPathEffects(GreenBeanAndPeaHarvestAddon.modDesc.handle, "modDesc.motionPathEffects.motionPathEffect", GreenBeanAndPeaHarvestAddon.currentModDirectory, GreenBeanAndPeaHarvestAddon.currentModName);

        local motionPathEffectsXMLFilename = getXMLString(GreenBeanAndPeaHarvestAddon.modDesc.handle, "modDesc.motionPathEffects#filename");

        if motionPathEffectsXMLFilename ~= nil then
            local motionPathEffectsXMLFile = XMLFile.load("motionPathXML", Utils.getFilename(motionPathEffectsXMLFilename, GreenBeanAndPeaHarvestAddon.currentModDirectory), GreenBeanAndPeaHarvestAddon.xmlSchema);

            if motionPathEffectsXMLFile ~= nil then
                g_motionPathEffectManager:loadMotionPathEffects(motionPathEffectsXMLFile.handle, "motionPathEffects.motionPathEffect", GreenBeanAndPeaHarvestAddon.currentModDirectory, GreenBeanAndPeaHarvestAddon.currentModName);

                motionPathEffectsXMLFile:delete();
            end;
        end;

        return true;
    end;

    MotionPathEffectManager.loadMapData = Utils.prependedFunction(MotionPathEffectManager.loadMapData, GreenBeanAndPeaHarvestAddon.motionPathEffectManagerLoadMapData);

    function GreenBeanAndPeaHarvestAddon:fruitTypeManagerLoadMapData(superFunc, xmlFile, missionInfo, baseDirectory)
        superFunc(self, xmlFile, missionInfo, baseDirectory);

        local fruitTypesXMLFilename = getXMLString(GreenBeanAndPeaHarvestAddon.modDesc.handle, "modDesc.fruitTypes#filename");

        if fruitTypesXMLFilename ~= nil then
            local fruitTypesXMLFile = XMLFile.load("fruitTypes", Utils.getFilename(fruitTypesXMLFilename, GreenBeanAndPeaHarvestAddon.currentModDirectory), GreenBeanAndPeaHarvestAddon.xmlSchema);

            if fruitTypesXMLFile ~= nil then
                g_fruitTypeManager:loadFruitTypes(fruitTypesXMLFile.handle, missionInfo, false);

                fruitTypesXMLFile:delete();
            end;
        end;
    end;

    FruitTypeManager.loadMapData = Utils.overwrittenFunction(FruitTypeManager.loadMapData, GreenBeanAndPeaHarvestAddon.fruitTypeManagerLoadMapData);
end;