-- load heightTypes, basically use default function
-- by modelleicher (Farming Agency)

loadHeightTypes = {}

local modDirectory = g_currentModDirectory

function loadHeightTypes.loadHeightTypesFromXML(self, superFunc, val1, val2)

    local returnValue = superFunc(self, val1, val2)

    if fileExists(modDirectory.."densityMapHeightTypes.xml") then
        local heightTypesXML = loadXMLFile("Bergwerk_heightTypes", modDirectory.."densityMapHeightTypes.xml")

        g_densityMapHeightManager:loadDensityMapHeightTypes(heightTypesXML, nil, modDirectory, false)
	    delete(heightTypesXML)
    else
        print("Bergwerk Warning: Can't load '"..tostring(modDirectory.."densityMapHeightTypes.xml").."' no custom HeightTypes for Bergwerk will be loaded!")
    end
    return returnValue
end

DensityMapHeightManager.loadDefaultTypes = Utils.overwrittenFunction(DensityMapHeightManager.loadDefaultTypes, loadHeightTypes.loadHeightTypesFromXML)
